/*
 * Decompiled with CFR 0.152.
 */
package jemu.core.device.cpcdos;

import CPCFileSystem.CPCFileSystem;
import JCPC.core.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import jemu.core.cpu.Z80;
import jemu.core.device.Device;
import jemu.core.samples.Samples;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.GateArray;
import jemu.ui.Switches;

public class CPCDos {
    protected boolean DEBUG = false;
    protected ByteArrayOutputStream CPCWriteBuffer;
    protected int CPCReadPos = 0;
    protected String DOSPath;
    protected Z80 z80;
    protected int StoreIY;
    protected int FWhere = 2048;
    protected boolean RdOpen = false;
    protected final String[] commands = new String[]{"FOpenin", "FOpenout", "FClosein", "FCloseout", "FRead ###", "FWrite +++", "FTestEOF", "FErase", "FRename", "FGetCat", "FGetDir", "FChDir", "---", "FReset"};
    boolean isReadASCII = false;
    byte[] RHead = new byte[128];
    byte[] CPCStream;
    String filename = "";
    protected int checksumpos = 67;
    boolean RdSave = false;
    String savename;
    CPCFileSystem filesystem = new CPCFileSystem();
    int CPCStreamPosition;
    int lastRead;
    int RdCount = 0;
    boolean EOFMet = false;
    public static boolean ledRead;
    public static boolean ledWrite;
    boolean initWrite = false;
    int CPCFileStart;
    boolean WrOpen = false;
    int writepos = 0;
    byte[] WHead = new byte[128];
    int blockpos = 0;
    boolean isASCII = false;
    String[] realNames;
    String[] dosNames;
    byte[] empty = new byte[14336];

    public CPCDos(Z80 z80) {
        this.z80 = z80;
        this.DOSPath = Settings.get("dos_path", "./CPCDOS/");
        File a = new File(this.DOSPath);
        if (!a.exists()) {
            a.mkdir();
        }
    }

    public void execute() {
        int A = this.z80.getAF() >> 8;
        if (this.DEBUG) {
            String com = this.commands[A];
            String hl = "&" + Util.hex((short)this.z80.getHL());
            String bc = "&" + Util.hex((short)this.z80.getBC());
            String de = "&" + Util.hex((short)this.z80.getDE());
            com = com.replace("###", hl + ", " + bc);
            com = com.replace("+++", hl + ", " + de);
            com = com.replace("---", "Regs.IY(" + this.z80.getIY() + "), " + this.StoreIY);
            System.out.println("CPDDosHandler: " + com);
        }
        switch (A) {
            case 0: {
                this.FOpenin();
                break;
            }
            case 1: {
                this.FOpenout();
                break;
            }
            case 2: {
                this.FClosein();
                break;
            }
            case 3: {
                this.FCloseout();
                break;
            }
            case 4: {
                this.FRead(this.z80.getHL(), this.z80.getBC());
                break;
            }
            case 5: {
                this.FWrite(this.z80.getHL(), this.z80.getDE());
                break;
            }
            case 6: {
                this.FTestEOF();
                break;
            }
            case 7: {
                this.FErase();
                break;
            }
            case 8: {
                this.FRename();
                break;
            }
            case 9: {
                this.FGetCat();
                break;
            }
            case 10: {
                this.FGetDir();
                break;
            }
            case 11: {
                this.FChDir();
                break;
            }
            case 12: {
                this.z80.setIY(this.StoreIY);
                break;
            }
            case 13: {
                this.FReset();
            }
        }
    }

    protected void flushROM() {
        this.FWhere = 2048;
        this.FWriteMem(this.empty);
        this.FWhere = 2048;
        this.FHiddenCat();
        this.isReadASCII = false;
        ledWrite = false;
        ledRead = false;
    }

    protected void FOpenin() {
        byte read;
        int i;
        int addr;
        this.flushROM();
        this.EOFMet = false;
        this.isReadASCII = false;
        this.lastRead = 0;
        this.CPCReadPos = 0;
        int buffaddr = addr = this.z80.getHL();
        int strlen = this.z80.getBC() >> 8;
        String toload = "";
        int toaddress = 0;
        byte[] buffer = new byte[2];
        int addr2 = 66;
        for (i = 0; i < 100; ++i) {
            if (((read = (byte)CPC.PEEK(addr2++)) & 0xFF) != 44) continue;
            buffer[0] = read = (byte)CPC.PEEK(addr2++);
            buffer[1] = read = (byte)CPC.PEEK(addr2++);
            toaddress = Device.getWord(buffer, 0);
            toaddress -= 14;
            break;
        }
        addr = buffaddr;
        for (i = 0; i < strlen; ++i) {
            int rd;
            if ((rd = (read = (byte)CPC.PEEK(addr++)) & 0xFF) == 239 || rd == 235) continue;
            if (rd == 163) {
                rd = 126;
            }
            toload = toload + (char)rd;
        }
        String file = toload;
        if ((file = file.replace(".", "\u00a7\u00a7\u00a7\u00a7")).contains("\u00a7\u00a7\u00a7\u00a7")) {
            String[] split = file.split("\u00a7\u00a7\u00a7\u00a7");
            if (split[0].length() > 8) {
                while (split[0].length() > 6) {
                    split[0] = split[0].substring(0, split[0].length() - 1);
                }
                split[0] = split[0] + "~1";
            }
            while (split[0].length() < 8) {
                split[0] = split[0] + " ";
            }
            while (split[1].length() > 3) {
                split[1] = split[1].substring(0, split[1].length() - 1);
            }
            file = split[0] + "." + split[1];
        }
        if (toload.toUpperCase().endsWith(".DSK")) {
            this.FClosein();
            try {
                toload = file;
                String dosname = "";
                for (int i2 = 0; i2 < this.dosNames.length; ++i2) {
                    if (!toload.toUpperCase().equals(this.dosNames[i2])) continue;
                    dosname = this.DOSPath + this.realNames[i2];
                    break;
                }
                File a = new File(dosname);
                byte[] diskdata = new byte[(int)a.length()];
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
                bin.read(diskdata);
                bin.close();
                GateArray.cpc.DSK_Load(dosname, diskdata, toaddress %= 2);
                this.z80.setF(64);
                Settings.set("file.drive" + Integer.toString(toaddress), dosname);
                this.FString("Loaded drive " + toaddress + ": " + toload);
            }
            catch (Exception e) {
                this.z80.setF(64);
                this.FString("File not found: " + toload);
            }
            return;
        }
        if (toload.toUpperCase().endsWith(".SNA")) {
            this.FClosein();
            this.z80.reset();
            final String lload = toload;
            Thread loadSNA = new Thread(){

                @Override
                public void run() {
                    String dosname = "";
                    dosname = CPCDos.this.DOSPath + lload;
                    for (int i = 0; i < CPCDos.this.dosNames.length; ++i) {
                        if (!lload.toUpperCase().equals(CPCDos.this.dosNames[i])) continue;
                        dosname = CPCDos.this.DOSPath + CPCDos.this.realNames[i];
                        break;
                    }
                    File a = new File(dosname);
                    byte[] diskdata = new byte[(int)a.length()];
                    try {
                        BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
                        bin.read(diskdata);
                        bin.close();
                        Thread.sleep(100L);
                        GateArray.cpc.reSync();
                        GateArray.cpc.SNA_Load(dosname, diskdata);
                        Thread.sleep(100L);
                        GateArray.cpc.reSync();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            loadSNA.start();
            return;
        }
        this.filename = toload;
        String fullpath = this.DOSPath + toload;
        this.StoreIY = this.z80.getIY();
        this.z80.setF(0);
        try {
            File a = new File(fullpath);
            if (!(a.exists() || (a = new File(fullpath + ".bas")).exists() || (a = new File(fullpath + ".bin")).exists())) {
                this.z80.setF(64);
                this.FString("File not found: " + toload);
                return;
            }
            this.z80.setF(this.z80.getF() | 0x40);
            BufferedInputStream bin = new BufferedInputStream(new FileInputStream(a));
            byte[] fulldata = new byte[(int)a.length()];
            bin.read(fulldata);
            bin.close();
            if (!CPC.CheckAMSDOS(fulldata)) {
                fulldata = this.makeFakeHeader(fulldata, 0);
                this.isReadASCII = true;
            }
            this.RdOpen = true;
            System.arraycopy(fulldata, 0, this.RHead, 0, 128);
            this.CPCStream = new byte[fulldata.length - 128];
            System.arraycopy(fulldata, 128, this.CPCStream, 0, this.CPCStream.length);
            int start = Device.getWord(fulldata, 21);
            this.writeHeader(start);
        }
        catch (Exception e) {
            this.z80.setF(0);
        }
    }

    protected byte[] makeFakeHeader(byte[] input, int start) {
        this.RHead = new byte[128];
        byte[] result = new byte[input.length + 128];
        for (int i = 1; i < 12; ++i) {
            this.RHead[i] = " ".getBytes()[0];
        }
        this.RHead[17] = -1;
        Device.putWord(this.RHead, 21, start);
        int sp1 = this.z80.getSP();
        boolean Load2 = (CPC.memory.readByte(sp1 + 11) == 235 || CPC.memory.readByte(sp1 + 11) == 236) && CPC.memory.readByte(sp1 + 5) == 0;
        this.RHead[18] = Load2 ? 22 : 22;
        this.RHead[23] = -1;
        int crc = input.length;
        this.RHead[24] = this.RHead[64] = (byte)(crc & 0xFF);
        this.RHead[19] = this.RHead[64];
        this.RHead[25] = this.RHead[65] = (byte)(crc >> 8);
        this.RHead[20] = this.RHead[65];
        this.RHead[66] = (byte)(crc >> 16);
        CPCFileSystem.put24Bit(this.RHead, this.checksumpos, CPCFileSystem.ChecksumAMSDOS(this.RHead));
        System.arraycopy(this.RHead, 0, result, 0, 128);
        System.arraycopy(input, 0, result, 128, input.length);
        return result;
    }

    protected void writeHeader(int start) {
        int toIX = this.z80.getIX();
        for (int i = 0; i < 69; ++i) {
            CPC.memory.writeByte(toIX + i, this.RHead[i]);
        }
        this.z80.setHL(toIX);
        this.z80.setDE(start);
        this.z80.setBC((this.RHead[24] & 0xFF) + (this.RHead[25] << 8));
        this.z80.setAF(this.z80.getAF() & 0xBE | this.RHead[18] << 8 | 1);
    }

    protected void FOpenout() {
        this.flushROM();
        this.isASCII = false;
        this.CPCWriteBuffer = new ByteArrayOutputStream();
        this.writepos = 0;
        int addr = this.z80.getHL();
        int strlen = this.z80.getBC() >> 8;
        String toload = "";
        for (int i = 0; i < strlen; ++i) {
            byte read = (byte)CPC.PEEK(addr++);
            toload = toload + (char)read;
        }
        toload = toload.replace("\"", "");
        toload = toload.replace("\u00a3", "~");
        this.WrOpen = true;
        this.savename = toload;
        this.RdSave = true;
        this.z80.setF(1);
    }

    protected void FClosein() {
        this.z80.setF(1);
        if (this.RdOpen) {
            this.z80.setF(this.z80.getF() - 1);
        } else {
            this.z80.setF(this.z80.getF() - 1);
        }
        ledRead = false;
        this.RdOpen = false;
        this.EOFMet = false;
        this.lastRead = 0;
    }

    protected void FCloseout() {
        this.flushROM();
        this.z80.setF(1);
        ledWrite = false;
        this.EOFMet = false;
        if (!this.initWrite) {
            this.WrOpen = false;
            this.writepos = 0;
            this.isASCII = false;
            return;
        }
        if (this.DEBUG) {
            System.out.print(Util.hex((short)this.CPCFileStart) + ",");
            System.out.println(Util.hex((short)this.writepos));
        }
        if (this.WrOpen) {
            int type = 2;
            this.savename = this.savename.replace(".", "#############");
            if (!this.isASCII) {
                if (this.CPCFileStart == 368) {
                    type = 0;
                    if (!this.savename.contains("#############")) {
                        this.savename = this.savename + ".BAS";
                    }
                } else if (!this.savename.contains("#############")) {
                    this.savename = this.savename + ".BIN";
                }
            }
            this.savename = this.savename.replace("#############", ".");
            File a = new File(this.DOSPath + this.savename.toUpperCase());
            if (a.exists()) {
                String bb = this.savename.replace(".", "#############");
                if (bb.contains("#############")) {
                    String[] g = bb.split("#############");
                    bb = g[0] + ".BAK";
                } else {
                    bb = bb + ".BAK";
                }
                File b = new File(this.DOSPath + bb);
                if (b.exists()) {
                    b.delete();
                }
                a.renameTo(b);
                a = new File(this.DOSPath + this.savename.toUpperCase());
            }
            try {
                byte[] buffer = this.CPCWriteBuffer.toByteArray();
                if (!this.isASCII) {
                    buffer = this.filesystem.makeHeader(type, this.CPCFileStart, this.writepos, type == 0 ? 368 : 0, this.savename.replace(".", ""), buffer);
                }
                if (this.initWrite) {
                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(a));
                    bos.write(buffer);
                    bos.close();
                }
                this.writepos = 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.WrOpen = false;
        } else {
            this.z80.setF(0);
        }
        this.WrOpen = false;
        this.writepos = 0;
        this.initWrite = false;
        this.isASCII = false;
    }

    protected void FRead(int hl, int bc) {
        this.z80.setF(1);
        int Address = hl & 0xFFFF;
        int len = bc & 0xFFFF;
        if (this.RdOpen) {
            ledRead = true;
            if (Switches.FloppySound) {
                Samples.TAPEMOTOR.play();
            }
            for (int i = 0; i < len; ++i) {
                try {
                    if (this.CPCStream[this.CPCReadPos + i] == 26 && this.isReadASCII) {
                        this.EOFMet = true;
                    }
                    if (!this.EOFMet) {
                        CPC.memory.writeByte(Address + i, this.CPCStream[this.CPCReadPos + i]);
                        continue;
                    }
                    CPC.memory.writeByte(Address + i, 26);
                    continue;
                }
                catch (Exception e) {
                    this.EOFMet = true;
                    if (this.isReadASCII) {
                        CPC.memory.writeByte(Address + i, 26);
                    }
                    this.RdOpen = false;
                    System.out.println(this.z80.getF());
                    if (this.WrOpen) break;
                    this.z80.setF(4);
                    break;
                }
            }
            ++this.RdCount;
            this.CPCReadPos += len;
        } else {
            this.z80.setF(this.z80.getF() - 1);
        }
    }

    protected void BlockWrite(byte[] WriteF, byte[] WBuff, int tlen) {
        System.arraycopy(WBuff, 0, WriteF, this.blockpos, tlen);
        this.blockpos += tlen;
    }

    protected void FWrite(int hl, int de) {
        this.z80.setF(1);
        if (this.DEBUG) {
            System.out.println("Z80 IX: " + Util.hex(this.z80.getIX()));
        }
        if (this.z80.getIX() == 0 && !this.initWrite) {
            this.isASCII = true;
            this.CPCFileStart = 0;
        } else if (this.z80.getIX() != 0 && !this.initWrite) {
            this.isASCII = false;
            this.CPCFileStart = hl;
        }
        this.initWrite = true;
        if (this.isASCII && this.WrOpen) {
            if (Switches.FloppySound) {
                Samples.TAPEMOTOR.play();
            }
            ledWrite = true;
            this.RdSave = true;
            int value = this.z80.getBC() >> 8;
            if (value != 26) {
                this.CPCWriteBuffer.write((byte)value);
                ++this.writepos;
            }
        } else if (!this.isASCII && this.WrOpen) {
            if (Switches.FloppySound) {
                Samples.TAPEMOTOR.play();
            }
            ledWrite = true;
            this.RdSave = true;
            int address = hl;
            int len = de;
            for (int i = address; i < address + len; ++i) {
                this.CPCWriteBuffer.write((byte)CPC.PEEK(i));
            }
            this.writepos += len;
        } else {
            this.z80.setF(0);
        }
    }

    protected void FTestEOF() {
        this.z80.setF(0);
        this.z80.setF(this.EOFMet ? 0 : 1);
    }

    public void killLEDs() {
        Thread killem = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                    ledRead = false;
                    ledWrite = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        killem.start();
    }

    protected void FErase() {
        this.flushROM();
        String addon = this.FGetString();
        String deleted = this.FGetString();
        boolean nothing = true;
        addon = addon.replace("*", "xxxxxxxxxxxxxxxxxx");
        addon = addon.replace("\u00a3", "~");
        String result = "";
        if (addon.contains("xxxxxxxxxxxxxxxxxx")) {
            for (int i = 0; i < this.dosNames.length; ++i) {
                File a;
                String filtername = this.dosNames[i].toUpperCase();
                String[] add = addon.split("xxxxxxxxxxxxxxxxxx");
                int addcount = 0;
                for (int k = 0; k < add.length; ++k) {
                    if (!filtername.contains(add[k].toUpperCase())) continue;
                    ++addcount;
                }
                if (addcount != add.length || addcount <= 0 || !(a = new File(this.DOSPath + this.realNames[i])).exists()) continue;
                a.delete();
                ledWrite = true;
                this.killLEDs();
                nothing = false;
                result = deleted + " erased";
            }
        } else {
            addon = addon.toUpperCase();
            for (int i = 0; i < this.dosNames.length; ++i) {
                if (!addon.equals(this.dosNames[i].replace(" ", ""))) continue;
                File a = new File(this.DOSPath + this.realNames[i]);
                if (!a.exists()) break;
                a.delete();
                ledWrite = true;
                this.killLEDs();
                result = deleted + " erased";
                nothing = false;
                break;
            }
        }
        if (nothing) {
            result = addon.replace("xxxxxxxxxxxxxxxxxx", "*") + " not found";
        }
        this.FString(result);
    }

    protected void FRename() {
        File a;
        this.flushROM();
        if (Switches.FloppySound) {
            Samples.TAPEMOTOR.play();
        }
        String newRename = this.FGetString();
        this.z80.setHL(this.z80.getDE());
        this.z80.setBC(this.z80.getBC() & 0xFF | this.z80.getBC() << 8);
        String oldRename = this.FGetString();
        for (int i = 0; i < this.dosNames.length; ++i) {
            if (this.DEBUG) {
                System.out.println(this.dosNames[i] + "," + oldRename.toUpperCase());
            }
            if (!oldRename.toUpperCase().equals(this.dosNames[i])) continue;
            oldRename = this.realNames[i];
            break;
        }
        if (this.DEBUG) {
            System.out.println(newRename);
            System.out.println(oldRename);
        }
        if ((a = new File(this.DOSPath + oldRename)).exists()) {
            ledWrite = true;
            this.killLEDs();
            a.renameTo(new File(this.DOSPath + newRename));
        } else {
            this.FString(oldRename + " not found");
        }
    }

    protected void FHiddenCat() {
        this.DOSPath = this.DOSPath.replace("\\", "/");
        File a = new File(this.DOSPath);
        this.realNames = a.list();
        this.dosNames = a.list();
        for (int i = 0; i < this.dosNames.length; ++i) {
            String file = this.dosNames[i].toUpperCase();
            file = file.replace(".", "\u00a7\u00a7\u00a7\u00a7");
            int index = 1;
            if (file.contains("\u00a7\u00a7\u00a7\u00a7")) {
                String[] split = file.split("\u00a7\u00a7\u00a7\u00a7");
                if (split[0].length() > 8) {
                    while (split[0].length() > 6) {
                        split[0] = split[0].substring(0, split[0].length() - 1);
                    }
                    for (int k = 0; k < i; ++k) {
                        if (!this.dosNames[k].contains(split[0])) continue;
                        ++index;
                    }
                    if (index > 9) {
                        split[0] = split[0].substring(0, split[0].length() - 1);
                    }
                    if (index > 99) {
                        split[0] = split[0].substring(0, split[0].length() - 1);
                    }
                    split[0] = split[0] + "~" + index;
                }
                while (split[0].length() < 8) {
                    split[0] = split[0] + " ";
                }
                while (split[1].length() > 3) {
                    split[1] = split[1].substring(0, split[1].length() - 1);
                }
                this.dosNames[i] = file = split[0] + "." + split[1];
            } else {
                if (file.length() > 8) {
                    while (file.length() > 6) {
                        file = file.substring(0, file.length() - 1);
                    }
                    for (int k = 0; k < i; ++k) {
                        if (!this.dosNames[k].contains(file)) continue;
                        ++index;
                    }
                    if (index > 9) {
                        file = file.substring(0, file.length() - 1);
                    }
                    if (index > 99) {
                        file = file.substring(0, file.length() - 1);
                    }
                    this.dosNames[i] = file = file + "~" + index;
                    while (file.length() < 12) {
                        file = file + " ";
                    }
                }
                while (file.length() < 12) {
                    file = file + " ";
                }
            }
            this.dosNames[i] = file;
        }
    }

    protected void FGetCat() {
        String[] list;
        this.flushROM();
        if (Switches.FloppySound) {
            Samples.TAPEMOTOR.play();
        }
        ledRead = true;
        this.killLEDs();
        this.FWhere = 2048;
        this.DOSPath = this.DOSPath.replace("\\", "/");
        String[] drive = this.DOSPath.split("/");
        this.FString("Drive: " + drive[0] + "/\r\n Path: " + this.DOSPath.replace(drive[0] + "/", ""));
        File a = new File(this.DOSPath);
        String[] dirlist = a.list();
        a = new File("../");
        if (a.exists()) {
            list = new String[dirlist.length + 2];
            list[0] = ".       ";
            list[1] = "..      ";
            System.arraycopy(dirlist, 0, list, 2, dirlist.length);
        } else {
            list = new String[dirlist.length + 1];
            list[0] = ".       ";
            System.arraycopy(dirlist, 0, list, 1, dirlist.length);
        }
        int files = list.length;
        long totalsize = 0L;
        for (int i = 0; i < list.length; ++i) {
            long fsize;
            double check;
            a = new File(this.DOSPath + list[i]);
            long size = a.length();
            if (a.isDirectory()) {
                size = 0L;
            }
            if ((check = (double)size / 1024.0) > (double)(fsize = size / 1024L)) {
                ++fsize;
            }
            totalsize += fsize;
            String file = list[i].toUpperCase();
            if (!a.isDirectory()) {
                file = file.replace(".", "\u00a7\u00a7\u00a7\u00a7");
            }
            int index = 1;
            if (file.contains("\u00a7\u00a7\u00a7\u00a7")) {
                String[] split = file.split("\u00a7\u00a7\u00a7\u00a7");
                while (split[1].length() > 3) {
                    split[1] = split[1].substring(0, split[1].length() - 1);
                }
                if (split[0].length() > 8) {
                    while (split[0].length() > 6) {
                        split[0] = split[0].substring(0, split[0].length() - 1);
                    }
                    for (int k = 0; k < i; ++k) {
                        if (!list[k].contains(split[0])) continue;
                        ++index;
                    }
                    if (index > 9) {
                        split[0] = split[0].substring(0, split[0].length() - 1);
                    }
                    if (index > 99) {
                        split[0] = split[0].substring(0, split[0].length() - 1);
                    }
                    split[0] = split[0] + "\u00a3" + index;
                }
                while (split[0].length() < 8) {
                    split[0] = split[0] + " ";
                }
                list[i] = file = split[0] + "." + split[1];
            } else {
                if (file.length() > 8) {
                    while (file.length() > 6) {
                        file = file.substring(0, file.length() - 1);
                    }
                    for (int k = 0; k < i; ++k) {
                        if (!list[k].contains(file)) continue;
                        ++index;
                    }
                    if (index > 9) {
                        file = file.substring(0, file.length() - 1);
                    }
                    if (index > 99) {
                        file = file.substring(0, file.length() - 1);
                    }
                    list[i] = file = file + "\u00a3" + index;
                }
                while (file.length() < 12) {
                    file = file + " ";
                }
            }
            while (file.length() < 12) {
                file = file + " ";
            }
            file = file + " ";
            String len = "" + fsize;
            String obj = "K";
            if (len.length() > 4) {
                len = "" + (fsize /= 1024L);
                if (len.length() > 4) {
                    len = "" + (fsize /= 1024L);
                    obj = "G";
                } else {
                    obj = "M";
                }
                while (len.length() < 4) {
                    len = " " + len;
                }
                len = len + obj;
            } else {
                while (len.length() < 4) {
                    len = " " + len;
                }
                len = len + obj;
            }
            if (a.isDirectory()) {
                len = "[dir]";
            }
            if (this.FWhere + file.length() > 14302) {
                this.FString("*ERR* DIR too long\n");
                break;
            }
            this.FString(file);
            this.FString(len);
        }
        String result = files + "";
        while (result.length() < 6) {
            result = " " + result;
        }
        if (files % 2 == 1 && GateArray.getSMode() != 0) {
            this.FString("  \r\n");
        }
        this.FString("  \r\n");
        result = result + " file(s)  ";
        this.FString(result);
        result = "  Total " + (int)totalsize + "K";
        this.FString(result);
    }

    protected void FGetDir() {
        String[] list;
        this.flushROM();
        if (Switches.FloppySound) {
            Samples.TAPEMOTOR.play();
        }
        ledRead = true;
        this.killLEDs();
        String addon = this.FGetString();
        addon = addon.replace("\u00a3", "~");
        boolean filter = false;
        if (addon.length() > 0) {
            filter = true;
        }
        if (this.DEBUG) {
            System.out.println(addon);
        }
        this.FWhere = 2048;
        this.DOSPath = this.DOSPath.replace("\\", "/");
        String[] drive = this.DOSPath.split("/");
        this.FString("Drive: " + drive[0] + "/\r\n Path: " + this.DOSPath.replace(drive[0] + "/", ""));
        File a = new File(this.DOSPath);
        String[] dirlist = a.list();
        a = new File("../");
        if (a.exists()) {
            list = new String[dirlist.length + 2];
            list[0] = ".       ";
            list[1] = "..      ";
            System.arraycopy(dirlist, 0, list, 2, dirlist.length);
        } else {
            list = new String[dirlist.length + 1];
            list[0] = ".       ";
            System.arraycopy(dirlist, 0, list, 1, dirlist.length);
        }
        int files = 0;
        long totalsize = 0L;
        for (int i = 0; i < list.length; ++i) {
            long fsize;
            a = new File(this.DOSPath + list[i]);
            long size = a.length();
            double check = (double)size / 1024.0;
            if (check > (double)(fsize = size / 1024L)) {
                ++fsize;
            }
            if (a.isDirectory()) {
                fsize = 0L;
            }
            String file = list[i].toUpperCase();
            if (!a.isDirectory()) {
                file = file.replace(".", "\u00a7\u00a7\u00a7\u00a7");
            }
            if (file.contains("\u00a7\u00a7\u00a7\u00a7")) {
                String[] split = file.split("\u00a7\u00a7\u00a7\u00a7");
                if (split[0].length() > 8) {
                    while (split[0].length() > 6) {
                        split[0] = split[0].substring(0, split[0].length() - 1);
                    }
                    split[0] = split[0] + "\u00a31";
                }
                while (split[0].length() < 8) {
                    split[0] = split[0] + " ";
                }
                while (split[1].length() > 3) {
                    split[1] = split[1].substring(0, split[1].length() - 1);
                }
                file = split[0] + "." + split[1];
            } else {
                if (file.length() > 8) {
                    while (file.length() > 6) {
                        file = file.substring(0, file.length() - 1);
                    }
                    file = file + "\u00a31";
                }
                while (file.length() < 12) {
                    file = file + " ";
                }
            }
            while (file.length() < 12) {
                file = file + " ";
            }
            if (this.FWhere + file.length() > 14302) {
                this.FString("*ERR* DIR too long\n");
                break;
            }
            if (filter) {
                String filtername = file.replace(" ", "");
                if ((addon = addon.replace("*", "xxxxxxxxxxxxxxxxxx")).contains("xxxxxxxxxxxxxxxxxx")) {
                    String[] add = addon.split("xxxxxxxxxxxxxxxxxx");
                    int addcount = 0;
                    for (int k = 0; k < add.length; ++k) {
                        if (!filtername.toUpperCase().contains(add[k].toUpperCase())) continue;
                        ++addcount;
                    }
                    if (addcount != add.length) continue;
                    file = file + "  ";
                    if (GateArray.getSMode() == 1 && files % 2 == 1) {
                        file = file + "\r\n\b";
                    }
                    if (GateArray.getSMode() == 2 && files % 5 == 4) {
                        file = file + "\r\n\b";
                    }
                    if (GateArray.getSMode() == 0) {
                        file = file + "\r\n\b";
                    }
                    totalsize += fsize;
                    this.FString(file);
                    ++files;
                    continue;
                }
                if (!filtername.toUpperCase().equals(addon.toUpperCase())) continue;
                file = file + "  ";
                if (GateArray.getSMode() == 1 && files % 2 == 1) {
                    file = file + "\r\n\b";
                }
                if (GateArray.getSMode() == 2 && files % 5 == 4) {
                    file = file + "\r\n\b";
                }
                if (GateArray.getSMode() == 0) {
                    file = file + "\r\n\b";
                }
                totalsize += fsize;
                this.FString(file);
                ++files;
                continue;
            }
            file = file + "  ";
            if (GateArray.getSMode() == 1 && files % 2 == 1) {
                file = file + "\r\n\b";
            }
            if (GateArray.getSMode() == 2 && files % 5 == 4) {
                file = file + "\r\n\b";
            }
            if (GateArray.getSMode() == 0) {
                file = file + "\r\n\b";
            }
            totalsize += fsize;
            this.FString(file);
            ++files;
        }
        String result = files + "";
        while (result.length() < 6) {
            result = " " + result;
        }
        if (files % 2 == 1) {
            this.FString("                    ");
        }
        this.FString("");
        result = result + " file(s)      Total " + (int)totalsize + "K";
        this.FString(result);
    }

    protected void FChDir() {
        this.flushROM();
        if (Switches.FloppySound) {
            Samples.TAPEMOTOR.play();
        }
        String oldDosPath = this.DOSPath;
        String newdir = this.FGetChString();
        if (newdir.contains(":")) {
            this.DOSPath = "";
        }
        newdir = this.DOSPath + newdir;
        File a = new File(newdir);
        this.z80.setF(0);
        if (a.exists()) {
            try {
                this.DOSPath = a.getCanonicalPath() + File.separator;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.DOSPath = this.DOSPath.replace("\\", "/");
            if (!this.DOSPath.endsWith("/")) {
                this.DOSPath = this.DOSPath + "/";
            }
            Settings.set("dos_path", this.DOSPath);
            this.z80.setF(1);
        } else {
            this.DOSPath = oldDosPath;
        }
    }

    public void FReset() {
        this.flushROM();
    }

    String FGetString() {
        String Result = "";
        for (int count = 1; count <= this.z80.getBC() >> 8; count = (int)((byte)(count + 1))) {
            char ch = (char)CPC.PEEK(this.z80.getHL() + count - 1);
            if (ch == ' ') continue;
            Result = Result + ch;
        }
        Result = Result.toUpperCase();
        Result = Result.replace("\u00a3", "~");
        return Result;
    }

    String FGetChString() {
        String Result = "";
        for (int count = 1; count <= this.z80.getBC() >> 8; count = (int)((byte)(count + 1))) {
            char ch = (char)CPC.PEEK(this.z80.getHL() + count - 1);
            Result = Result + ch;
        }
        Result = Result.toUpperCase();
        Result = Result.replace("\u00a3", "~");
        return Result;
    }

    protected void FString(String S) {
        int len = S.length();
        byte[] buffer = new byte[]{len};
        this.FWriteMem(buffer);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (int i = 0; i < len; ++i) {
            bos.write((byte)S.charAt(i));
        }
        this.FWriteMem(bos.toByteArray());
    }

    protected void FWriteMem(byte[] Buff) {
        if (Buff == null || Buff.length == 0) {
            return;
        }
        int rombase = CPC.memory.getUpperBase();
        int buffLen = Buff.length;
        if (buffLen > 14336) {
            buffLen = 14336;
        }
        System.arraycopy(Buff, 0, CPC.memory.getMemory(), rombase + this.FWhere, buffLen);
        this.FWhere += Buff.length;
    }
}

